import random

#%% Python quiz - answer randomly 10 of 20 questions
print('Willkommen zu meinem Python-Quiz!')
print('Teste dein Python-Wissen und beantworte 10 Fragen.')
print('Beispielfrage: Python ist eine gute Programmiersprache, weil:')
print('a: sie einfach ist')
print('b: sie open-source ist')
print('c: sie eine grosse Standardbibilothek hat')
print('d: ich Schokolade mag')
print('Richtige Antwort: abc')

#%% Dictionary containing the 20 Questions, Possible answers and the correct answer
question_catalogue = {0:{'Question':'Welche Bibliothek(en) gehört(en) zur Python Standard-Bibliothek?',
                         'Possible_answers':('a: Tensorflow','b: Os', 'c: Random', 'd: Getcwd', 'e: Enum'),
                         'Answer':set('bce')},
                      1:{'Question':'Welche(r) Datentyp gehört(en) zu den Basis-Datenstrukturen in Python?',
                         'Possible_answers':('a: Integer','b: Lists', 'c: Floats', 'd: Tuples', 'e: Dictionaries' ),
                         'Answer':set('bde')},
                      2:{'Question':'Welche(r) Datentyp gehört(en) zu den Basis-Datenstrukturen in Python?',
                         'Possible_answers':('a: Lists','b: Dictionaries', 'c: Functions', 'd: Tuples', 'e: Sets' ),
                         'Answer':set('abde')},
                      3:{'Question':'Welche(r) Datentyp sind veraenderlich?',
                         'Possible_answers':('a: Lists','b: Dictionaries', 'c: Sets', 'd: Tuples', 'e: Alle' ),
                         'Answer':set('abc')},
                      4:{'Question':'Welche(r) Datentyp sind geordnet?',
                         'Possible_answers':('a: Lists','b: Dictionaries', 'c: Sets', 'd: Tuples', 'e: Alle' ),
                         'Answer':set('ad')},
                      5:{'Question':'Wie erzeuge ich ein leeres Tuple?',
                         'Possible_answers':('a: tuple()', 'b: {}', 'c: ()', 'd: (,)', 'e: []' ),
                         'Answer':set('ac')},
                      6:{'Question':'Was stellen diese zwei Klammern da {}?',
                         'Possible_answers':('a: eine leere Liste', 'b: einen leeren String', 'c: ein leeres Set', 'd: ein leeres Tuple', 'e: ein leeres Dictionary' ),
                         'Answer':set('e')},
                      7:{'Question':'Wo sucht der Python-Interpreter nach Modulen?',
                         'Possible_answers':('a: im aktuellen Arbeitsverzeichnis', 'b: im Ordner der Standardbibliothek', 'c: im anzugebenen Pfad', 'd: ueberall', 'e: im Ordner fuer Site-Packages' ),
                         'Answer':set('abe')},
                      8:{'Question':'Wie bestimme ich die Laenge einer Liste my_list?',
                         'Possible_answers':('a: my_list.size()', 'b: my_list.length()', 'c: length(my_list)', 'd: my_list.len()', 'e: len(my_list)' ),
                         'Answer':set('e')},
                      9:{'Question':'An welchem Kennwort erkenne ich Funktionen in Python?',
                         'Possible_answers':('a: func', 'b: def', 'c: meth', 'd: function', 'e: defintion' ),
                         'Answer':set('b')},
                      10:{'Question':'Was bedeutet PEP?',
                         'Possible_answers':('a: Python Evolution Protocol', 'b: Python Enhancement Priority', 'c: Python Easy Programming', 'd: Python Enhancement Protocol', 'e: Python Evolution Priority' ),
                         'Answer':set('d')},
                      11:{'Question':'Welche Ausage(n) stimmt(en)?',
                         'Possible_answers':('a: Listen sind veraenderlich','b: Listen sind geordnet', 'c: Die Objekte einer Liste haben immer den gleichen Datentyp'),
                          'Answer':set('ab')},
                      12:{'Question':'Welche Ausage(n) stimmt(en)?',
                         'Possible_answers':('a: Dictionaries sind geordnet','b: Dictionaries können Dictionaries enthalten', 'c: Dictionaries sind veraenderlich'),
                          'Answer':set('bc')},
                      13:{'Question':'Welche Ausage(n) stimmt(en)?',
                         'Possible_answers':('a: Module koennen aus mehreren Funktionen bestehen','b: Eine Funktion besteht aus mehreren Modulen', 'c: Mehrere Module koennen Funktionen mit dem gleichen Namen beinhalten'),
                          'Answer':set('ac')},
                      14:{'Question':'Welche Ausage(n) stimmt(en)?',
                         'Possible_answers':('a: Listen koennen Duplikate enthalten','b: Tuples koennen Duplikate enthalten', 'c: Sets koennen Duplikate enthalten'),
                          'Answer':set('ab')},
                      15:{'Question':'Wie erzeuge ich ein Tuple mit nur einem Objekt?',
                         'Possible_answers':('a: ("Na so!")', "b: ('Na so!')", 'c: ("Na so!",)', 'd: tuple("Na so!")', "e: tuple('Na so!')"),
                         'Answer':set('cde')},
                      16:{'Question':'In Python ist die Einrueckung der Zeilen wichtig.',
                          'Possible_answers':('a: Richtig','b: Falsch'),
                          'Answer':set('a')},
                      17:{'Question':'Funktionen muessen immer einen Wert mit return zurueck geben.',
                          'Possible_answers':('a: Richtig','b: Falsch'),
                          'Answer':set('b')},
                      18:{'Question':'Welchen Wahrheitswert hat eine nicht leere Liste?',
                          'Possible_answers':('a: True','b: False'),
                          'Answer':set('a')},
                      19:{'Question':'Der Wahrheitswert einer negativen Zahl ist False',
                          'Possible_answers':('a: Richtig','b: Falsch'),
                          'Answer':set('b')}}

#%% Own functions
def ask_question(number,questions):
    """Function select a random number n of the list number,
       print the n-th question of the question catalogue and
       returns the correct answer"""
    selected_question = number.pop(random.randint(0,len(number)-1))
    print(questions[selected_question]['Question'])
    for answer_option in questions[selected_question]['Possible_answers']:
        print(answer_option)
    return questions[selected_question]['Answer']    

def check_input(user_input, answer):
    """Function checks if the user_input has the right format,
       if not the user can repeat the answer three times,
       if the format is correct the user_input is compared with the correct answer and
       a boolean is returned"""
    for i in range(3):
        if set(user_input).difference(set('abcde ')):
            if i == 2:
                print('Du hast 3 Mal das falsche Format verwendet. Die Frage wird als falsch geantwortet gewertet')
                return False
            else:
                print('Falsches Antwortformat. Bitte versuche es erneut. Verwende bitte nur kleingeschriebene, gueltige Antwortbuchstaben, siehe Beispielfrage oben.')
                user_input=input('Deine Antwort:')
        else:
            return set(user_input).difference({' '}) == answer
        
#%% Main programme
count_corr_answer = 0
question_list = list(range(20))

for i in range(10):
    print()
    print("Frage", i+1, ":")
    correct_answer = ask_question(question_list,question_catalogue)
    user_answer=input('Deine Antwort:')
    if check_input(user_answer, correct_answer):
        print('Richtige Antwort')
        count_corr_answer += 1
    else:
        print('Leider falsch. Die richtige Antwort ist:',sorted(correct_answer))
print()
print('Du hast', count_corr_answer*10, '% der Fragen richtig beantwortet. Spiele gerne noch eine Runde!')
    
